unit CheckBox3S;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TCheckBox3S = class(TCheckBox)
  private
    FAllapotszam : integer;
    procedure SetAllapotszam(v:integer);
  public
    szoveg: array[cbUnchecked..cbGrayed] of ShortString;
    procedure Toggle; override;
    constructor Create(AOwner:TComponent); override;
  published
     property Allapotszam : integer read FAllapotszam write SetAllapotszam;
  end;

procedure Register;

implementation


{ Az j jellngyzet konstruktora}
constructor TCheckBox3S.Create(AOwner:TComponent);
begin
   inherited Create(AOwner);
   Allapotszam:=3;
   Szoveg[cbUnchecked]:='Nem kivlasztott';
   Szoveg[cbChecked]:='Kivlasztott';
   Szoveg[cbGrayed]:='Szrktett';
end;

procedure TCheckBox3S.SetAllapotszam(v:integer);
begin
  if v in [1..3] then  FAllapotszam:=v
                 else  FAllapotszam:=3;
end;

procedure TCheckBox3S.Toggle;
begin
  beep;
  State := TCheckBoxState((Ord(state)+1) mod Allapotszam);
  Caption:=Szoveg[State];
end;

procedure Register;
begin
  RegisterComponents('Samples', [TCheckBox3S]);
end;

end.
